/*
 * Decompiled with CFR 0.152.
 */
package com.janetfilter.plugins.sg;

import com.janetfilter.core.Environment;
import com.janetfilter.core.commons.DebugInfo;
import com.janetfilter.core.models.FilterRule;
import com.janetfilter.core.plugin.MyTransformer;
import com.janetfilter.core.plugin.PluginConfig;
import com.janetfilter.core.plugin.PluginEntry;
import com.janetfilter.plugins.sg.ValidationManagerTransformer;
import com.janetfilter.plugins.sg.ValidationTransformer;
import java.util.ArrayList;
import java.util.List;

public class ValidPlugin
implements PluginEntry {
    private final List<MyTransformer> transformers = new ArrayList<MyTransformer>();

    public void init(Environment environment, PluginConfig config) {
        List filtersRules = config.getBySection("Methods");
        for (FilterRule rule : filtersRules) {
            String ruleStr = rule.getRule();
            String[] methodInfo = ruleStr.split("(?<!\\\\)\\|", 3);
            if (methodInfo.length != 3) {
                DebugInfo.output((String)("Invalid configuration: " + rule + ", skipped. should be <clsname>|<methodname>|<method desc"));
            }
            String className = methodInfo[0].trim().replaceAll("\\\\\\|", "|");
            String methodName = methodInfo[1].trim().replaceAll("\\\\\\|", "|");
            String methodDesc = methodInfo[2].trim().replaceAll("\\\\\\|", "|");
            switch (rule.getType()) {
                case EQUAL: {
                    this.transformers.add(new ValidationTransformer(className, methodName, methodDesc));
                    break;
                }
                case REGEXP: {
                    this.transformers.add(new ValidationManagerTransformer(className, methodName, methodDesc));
                    break;
                }
            }
        }
    }

    public String getName() {
        return "SgValid";
    }

    public String getAuthor() {
        return "mz";
    }

    public String getVersion() {
        return "v1.0.0";
    }

    public String getDescription() {
        return "you know if you know, otherwise, no need to know";
    }

    public List<MyTransformer> getTransformers() {
        return this.transformers;
    }
}

